package com.sample.introtoandroid.simplefiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.util.Log;


public class SimpleFilesActivity extends Activity {
    private static final String DEBUG_TAG = "Dziennik aktywności SimpleFilesActivity";
    private static final String SOME_FILE_CONTENTS = "Żółwie morskie można spotkać na całym świecie, lecz wszystkie ich gatunki są na listach gatunków zagrożonych. Należy do nich także żółw Karetta.";
    private static final String MORE_FILE_CONTENTS = "Żółwie Karettta rodzą się na Pacyfiku, na plażach wysp japońskich. Małe żółwiki wykluwają się z jaj w nocy, co ma je ochronić przed wypatrzeniem przez drapieżniki i pożarciem. Wędrują do oceanu podążając w stronę światła. W przeszłości najjaśniejszym światłem w nocy było samo morze, jednak obecnie światła używane przez ludzi mogą mylić małe żółwie i zakłócać ich wędrówkę do oceanu. Jedynie części z nich udaje się pokonać piaszczystą plażę i bezpiecznie dotrzeć do wody.";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_simple_files);

        // To co najważniejsze w tym przykładzie - różne operacje na plikach.
        runFileAccessExample();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_simple_files, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    public void runFileAccessExample() {
        Log.i(DEBUG_TAG, "Begin File Example");
        String file1 = "file1.txt";

        // Jeśli plik istnieje, to go usuwamy.
        if (Arrays.binarySearch(fileList(), file1) >= 0) {
            // Usuwamy stary plik.
            deleteFile(file1);
        }

        // Zapisujemy tekst w pliku, tworząc go w razie konieczności.
        FileOutputStream fos;
        try {
            fos = openFileOutput(file1, MODE_PRIVATE);
            fos.write(SOME_FILE_CONTENTS.getBytes());
            fos.close();
            Log.i(DEBUG_TAG, "Zapisano tekst w pliku: " + file1);
        } catch (Exception e) {
            Log.i(DEBUG_TAG, "Wywołanie openFileOutput (nowy plik) zgłosiło wyjątek: "
                    + e.getMessage());
        }

        // Wczytujemy całą zawartość pliku i wyświetlamy ją jako jeden łańcuch znaków.
        readAppFileAndLog(file1);
        // Ponownie wczytujemy zawartość pliku, we fragmentach po 70 znaków.
        readAppFileAndLogAsString(file1);

        // Dopisujemy tekst do pliku.
        try {
            fos = openFileOutput(file1, MODE_APPEND);
            fos.write(MORE_FILE_CONTENTS.getBytes());
            fos.close();
            Log.i(DEBUG_TAG, "Dopisano tekst do pliku: " + file1);
        } catch (Exception e) {
            Log.i(DEBUG_TAG, "Wywołanie openFileOutput (plik) zgłosiło wyjątek: "
                    + e.getMessage());
        }

        // Read back our file again so we can see the appended text
        readAppFileAndLog(file1);

        Log.i(DEBUG_TAG, "INSPECTING APPLICATION FILE DIRECTORY at Context.getFilesDir()");
        File pathForAppFiles = getFilesDir();
        logFileDetails(pathForAppFiles);

        Log.i(DEBUG_TAG, "Wyświetlamy pliki w katalogu " + pathForAppFiles.getAbsolutePath());
        String[] fileList = pathForAppFiles.list();
        for(int i=0; i< fileList.length; i++)        {
            Log.i(DEBUG_TAG, "Plik " + i+": " + fileList[i] );
        }

        Log.i(DEBUG_TAG, "SPRAWDZENIE KATALOGU APLIKACJI określonego przez wywołanie Context.getCacheDir()");
        File pathCacheDir = getCacheDir();
        logFileDetails(pathCacheDir);

        String strCacheFileName = "myCacheFile.cache";
        File newCacheFile = new File(pathCacheDir, strCacheFileName);

        try {
            Log.i(DEBUG_TAG, "Tworzymy nowy plik w katalogu pamięci podręcznej: " + strCacheFileName);
            final boolean newFile = newCacheFile.createNewFile();
            Log.i(DEBUG_TAG, "Utworzono nowy plik w katalogu pamięci podręcznej: " + newFile);
            logFileDetails(newCacheFile);

            // Write to the file
            FileOutputStream foCache = new FileOutputStream(newCacheFile.getAbsolutePath());
            foCache.write(SOME_FILE_CONTENTS.getBytes());
            foCache.close();

            // Read what we wrote to the file back
            Log.i(DEBUG_TAG, "ZAPISANA ZAWARTOŚĆ PLIKU:");
            readAnyFileAndLog(newCacheFile.getAbsolutePath());
        } catch (Exception e) {
            Log.i(DEBUG_TAG, "Wywołanie createNewFile zgłosiło wyjątek: "
                    + e.getMessage());
        }

        Log.i(DEBUG_TAG, "Wyświetlamy pliki w katalogu " + pathCacheDir.getAbsolutePath());
        String[] fileListCache = pathCacheDir.list();
        for(int i=0; i< fileListCache.length; i++)        {
            Log.i(DEBUG_TAG, "Plik " + i+": " + fileListCache[i] );
        }

        Log.i(DEBUG_TAG, "Usuwamy plik z katalogu pamięci podręcznej: " + strCacheFileName);
        final boolean cacheDelete = newCacheFile.delete();
        Log.i(DEBUG_TAG, "Usunięto plik z katalogu pamięci podręcznej: " + cacheDelete);

        Log.i(DEBUG_TAG, "Wyświetlamy pliki w katalogu " + pathCacheDir.getAbsolutePath());
        String[] fileListCacheRefeshed = pathCacheDir.list();
        for(int i=0; i< fileListCacheRefeshed.length; i++)        {
            Log.i(DEBUG_TAG, "Plik " + i+": " + fileListCacheRefeshed[i] );
        }

        // Wracamy do funkcji obiektu Context...
        Log.i(DEBUG_TAG, "Próbujemy usunąć utworzony wcześniej plik: " + file1);
        if (deleteFile(file1)) {
            Log.i(DEBUG_TAG, "Usuwanie pliku: Udało się usunąć plik" + file1 + ".");
        }

        Log.i(DEBUG_TAG, "Koniec przykładu prezentującego operacje na plikach.");
    }

    // Log some file details
    public void logFileDetails(File file)	{
        if(file.isDirectory())        {
            Log.i(DEBUG_TAG, file.getAbsolutePath() + " jest KATALOGIEM");
        }
        if(file.isFile())        {
            Log.i(DEBUG_TAG, file.getAbsolutePath() + " jest PLIKIEM");
        }
        if(file.isHidden())        {
            Log.i(DEBUG_TAG, file.getAbsolutePath() + " jest PLIKIEM UKRYTYM");
        }
        if(file.exists())        {
            Log.i(DEBUG_TAG, file.getAbsolutePath() + " ISTNIEJE");
        }
        if(file.canRead())        {
            Log.i(DEBUG_TAG, file.getAbsolutePath() + " MOŻNA ODCZYTAĆ");
        }
        if(file.canWrite())        {
            Log.i(DEBUG_TAG, file.getAbsolutePath() + " MOŻNA ZAPISAĆ");
        }
    }

    // Metoda zapisuje plik dodając do jego pierwotnej zawartości znak nowego 
    // wiersza co każde 70 znaków (dzięki temu komunikaty lepiej wyglądają 
    // w oknie Logcat).
    // Zazwyczaj operacje tego typu, potencjalnie długotrwałe, są wykonywane w odrębnych wątkach,
    // a w interfejsie użytkownika jest prezentowany pasek postępów pokazujący proces wczytywania
    // pliku do pamięci. Jednak ten przykład z założenia ma być jak najprostszy, gdyż dziennik 
    // naszej pogawędki jest niewielki. Przykład wykorzystania innego wątku do wykonywania działań
    // tego typu można znaleźć w aplikacji FileStreamOfConsciousness.
    
    // Ta metoda operuje wyłącznie na plikach umieszczonych w katalogu aplikacji.
    public void readAppFileAndLog(String filename) {
        FileInputStream fis;

        try {
            fis = openFileInput(filename);
            StringBuffer sBuffer = new StringBuffer();
            int chunkSize = 70;
            byte[] bf = new byte[chunkSize];

            // Wczytujemy po 70 znaków.
            while ((fis.read(bf, 0, chunkSize)) != -1) {
                String str = new String(bf);
                sBuffer.append(str);
                sBuffer.append("\n");
                if(fis.available() < 50)
                {
                    Arrays.fill(bf, 0, chunkSize, (byte) ' '); // Czyścimy bufor, dzięki czemu następny wiersz tekstu będzie zawierał wyłącznie pozostałe bajty.
                }
            }
            fis.close();

            Log.i(DEBUG_TAG, "Zawartość pliku:\n" + sBuffer.toString());
            Log.i(DEBUG_TAG, "\nEOF");
        } catch (Exception e) {
            Log.i(DEBUG_TAG, "Wywołanie openFileInput zgłosiło wyjątek: "+ e.getMessage());
        }

    }

    // Metoda zapisuje plik dodając znak nowego wiersza co 70 znaków pierwotnej 
    // zawartości pliku (dzięki temu komunikaty lepiej wyglądają w oknie Logcat).
    // Takie operacje zazwyczaj są wykonywane w osobnych wątkach.
    public void readAnyFileAndLog(String filename) {
        FileInputStream fis;

        try {
            fis = new FileInputStream(filename);
            StringBuffer sBuffer = new StringBuffer();
            int chunkSize = 70;
            byte[] bf = new byte[chunkSize];

            // Wczytujemy po 70 znaków.
            while ((fis.read(bf, 0, chunkSize)) != -1) {
                String str = new String(bf);
                sBuffer.append(str);
                sBuffer.append("\n");
                if(fis.available() < 50)
                {
                    Arrays.fill(bf, 0, chunkSize, (byte) ' '); // Czyścimy bufor, dzięki czemu następny wiersz tekstu będzie zawierał wyłącznie pozostałe bajty.
                }
            }

            fis.close();

            Log.i(DEBUG_TAG, "Zawartość pliku:\n" + sBuffer.toString());
            Log.i(DEBUG_TAG, "\nEOF");
        } catch (Exception e) {
            Log.i(DEBUG_TAG, "Wywołanie openFileInput zgłosiło wyjątek: "+ e.getMessage());
        }
    }

    // Metoda zapisuje zawartość pliku w dzienniku jako jeden długi łańcuch znaków.
    // Takie operacje zazwyczaj są wykonywane w osobnych wątkach.
    public void readAppFileAndLogAsString(String filename) {
        FileInputStream fis;

        try {
            fis = openFileInput(filename);
            StringBuffer sBuffer = new StringBuffer();
            BufferedReader dataIO = new BufferedReader (new InputStreamReader(fis));
            String strLine;

            // Wczytujemy zawartość pliku po jednym wierszu.
            while ((strLine = dataIO.readLine()) != null) {
                sBuffer.append(strLine);
                sBuffer.append("\n");
            }

            dataIO.close();
            fis.close();

            Log.i(DEBUG_TAG, "Zawartość pliku:\n" + sBuffer.toString());
            Log.i(DEBUG_TAG, "\nEOF");
        } catch (Exception e) {
            Log.i(DEBUG_TAG, "Wywołanie openFileInput zgłosiło wyjątek: "+ e.getMessage());
        }
    }
}
